/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.networksettings;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetworkSettingsValidation {
    public static final int OK = 0;
    public static final int INVALID_FORMAT = 1;
    public static final int INVALID_RANGE = 2;
    public static final int INVALID_NULL = 3;
    public static final int INVALID_TOO_SHORT = 4;
    public static final int INVALID_TOO_LONG = 5;
    public static final int INVALID_CHARACTERS = 6;
    public static final int INTERNAL_ERROR = 9999;
    private static final int CONTINUE = 0;
    private static final int END = 1;
    private static final int ERR = 2;
    private static Pattern ipAdr = Pattern.compile("([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})");
    private static Pattern twoCharacterHostName = Pattern.compile("[a-zA-Z0-9]+");
    private static Pattern multiCharacterHostName = Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]{1}");
    private static Pattern domainName = Pattern.compile("(?:([\\w\\-]+)(?:\\.)){0,1}(?:([\\w\\-]+)(?:\\.)){0,1}(?:([\\w\\-]+)(?:\\.)){0,1}(?:([\\w\\-]+)(?:\\.)){1}([\\w\\-]+){1}");

    public static int validateIPAddress(String string) {
        int n = 1;
        if (string == null) {
            return 3;
        }
        int[] nArray = NetworkSettingsValidation.validateIPAdr(string);
        int n2 = nArray.length;
        if (n2 > 0) {
            n = nArray[n2 - 1];
        }
        if (n == 0) {
            for (int i = 0; i < n2 - 1; ++i) {
                if (nArray[i] >= 0 && nArray[i] <= 255) continue;
                n = 2;
                break;
            }
        }
        return n;
    }

    public static int validateNetworkMask(String string) {
        int n = 1;
        if (string == null) {
            return 3;
        }
        int[] nArray = NetworkSettingsValidation.validateIPAdr(string);
        int n2 = nArray.length;
        if (n2 > 0) {
            n = nArray[n2 - 1];
        }
        int n3 = 2;
        if (n == 0) {
            n = n2 - 1 != 4 ? 1 : ((n3 = NetworkSettingsValidation.checkMask(nArray[0])) == 2 ? 2 : (n3 == 1 ? (nArray[1] != 0 || nArray[2] != 0 || nArray[3] != 0 ? 2 : 0) : ((n3 = NetworkSettingsValidation.checkMask(nArray[1])) == 2 ? 2 : (n3 == 1 ? (nArray[2] != 0 || nArray[3] != 0 ? 2 : 0) : ((n3 = NetworkSettingsValidation.checkMask(nArray[2])) == 2 ? 2 : (n3 == 1 ? (nArray[3] != 0 ? 2 : 0) : ((n3 = NetworkSettingsValidation.checkMask(nArray[3])) == 2 ? 2 : (n3 == 1 ? 0 : 0))))))));
        }
        return n;
    }

    private static int checkMask(int n) {
        if (n == 255) {
            return 0;
        }
        if (n == 192 || n == 224 || n == 240 || n == 248 || n == 252 || n == 254 || n == 128 || n == 0) {
            return 1;
        }
        return 2;
    }

    private static synchronized int[] validateIPAdr(String string) {
        int n = 0;
        int[] nArray = new int[1];
        Matcher matcher = ipAdr.matcher(string);
        if (matcher.matches()) {
            n = 0;
            int n2 = matcher.groupCount();
            if (n2 != 4) {
                n = 1;
            } else {
                nArray = new int[n2 + 1];
                String string2 = "";
                for (int i = 1; i < n2 + 1; ++i) {
                    string2 = matcher.group(i);
                    nArray[i - 1] = Integer.parseInt(string2);
                }
            }
        } else {
            n = 1;
        }
        nArray[nArray.length - 1] = n;
        return nArray;
    }

    public static synchronized int validateHostName(String string) {
        if (string == null) {
            return 3;
        }
        int n = string.length();
        if (n < 1) {
            return 4;
        }
        if (n > 63) {
            return 5;
        }
        if (n < 3) {
            Matcher matcher = twoCharacterHostName.matcher(string);
            if (matcher.matches()) {
                return 0;
            }
            return 6;
        }
        Matcher matcher = multiCharacterHostName.matcher(string);
        if (matcher.matches()) {
            return 0;
        }
        return 6;
    }

    public static synchronized int validateDomainName(String string) {
        if (string == null) {
            return 3;
        }
        if (string.length() > 255) {
            return 5;
        }
        if (string.length() < 3) {
            return 4;
        }
        int n = 0;
        Matcher matcher = domainName.matcher(string);
        if (matcher.matches()) {
            n = 0;
            int n2 = matcher.groupCount();
            String string2 = "";
            for (int i = 1; i < n2 + 1 && ((string2 = matcher.group(i)) == null || (n = NetworkSettingsValidation.validateHostName(string2)) <= 0); ++i) {
            }
        } else {
            n = 1;
        }
        return n;
    }
}

